<?php

require('vendor/autoload.php');
require(__DIR__ . '/tests/VerifiedBarcodeTest.php');
$verifiedFiles = VerifiedBarcodeTest::$supportedBarcodes;

$result = [];
$result[] = '# Examples of supported barcodes';
$result[] = 'These are examples of supported barcodes with this library.';
$result[] = 'All types can be found in the src/Types directory.';
$result[] = '';

foreach ($verifiedFiles as $verifiedFile) {
    $result[] = '### ' . substr($verifiedFile['type'], strrpos($verifiedFile['type'], '\\') + 1);
    foreach ($verifiedFile['barcodes'] as $barcode) {
        $result[] = sprintf(
            '![Barcode %s as %s](tests/verified-files/%s.svg)',
            $barcode,
            $verifiedFile['type'],
            Picqer\Barcode\Helpers\StringHelpers::getSafeFilenameFrom($verifiedFile['type'] . '-' . $barcode)
        );
    }
}

$result[] = '';
$result[] = '*This file is generated by generate-examples.php*';

file_put_contents('examples.md', implode(PHP_EOL . PHP_EOL, $result));
